% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hospital_in_out_dates.R
\name{hospital_in_out_dates}
\alias{hospital_in_out_dates}
\title{Hospital IN/OUT dates}
\usage{
hospital_in_out_dates(
  data,
  person_id = "id",
  hospital = list(org_code = "organisation_code_of_provider", event_date = "ev_date",
    ae_arrive = "arrival_date", ae_depart = "departure_date", ae_discharge =
    "ecds_discharge", in_spell_start = "spell_start_date", in_spell_end =
    "spell_end_date", in_discharge = "discharge_destination")
)
}
\arguments{
\item{data}{A linked table containing A&E and inpatient records (typically the
output of \code{link_ae_inpatient()}), including person/event identifiers and
date fields.}

\item{person_id}{Quoted column name for the unique patient identifier.}

\item{hospital}{A named \strong{list} specifying column names (all quoted) for:
\describe{
\item{\code{org_code}}{Organisation code (optional; used to scope grouping).}
\item{\code{event_date}}{Index date to compare against (e.g., \code{specimen_date}).}
\item{\code{ae_arrive}}{ECDS arrival date.}
\item{\code{ae_depart}}{ECDS departure date.}
\item{\code{ae_discharge}}{ECDS discharge status (use grouped values if available).}
\item{\code{in_spell_start}}{Inpatient spell start date.}
\item{\code{in_spell_end}}{Inpatient spell end date.}
\item{\code{in_discharge}}{Inpatient discharge destination (grouped recommended).}
}}
}
\value{
A \code{data.table} equal to \code{data} with additional columns:
\describe{
\item{\code{hospital_in}}{Derived hospital admission date for the relevant stay.}
\item{\code{hospital_out}}{Derived hospital discharge date for the relevant stay.}
\item{\code{hospital_event_rank}}{Rank of suitability of the hospital window for the
given person/event (1 = most suitable).}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Derives per‑patient \strong{hospital entry (\code{hospital_in})} and \strong{exit (\code{hospital_out})}
dates by reconciling A&E (ECDS) attendances and inpatient (HES/SUS) spells.
Applies a simple ranking to determine the most relevant hospital period around
an index event date (e.g., a specimen collection date).

\describe{
\item{"1"}{Current admissions take priority}
\item{"2"}{When conflicting on the same day, inpatient admissions take priority over A&E emergency care data}
\item{"3"}{Where a patient has a linked A&E admission to a hospital inpatient stay, the A&E admission date is used}
\item{"4"}{Where a patient has a positive test between two hospital stays the most recent completed hospital stay prior to the test is retained except if the time between these events is greater than 14 days, then the first admission following the test is retained}
}
}
\note{
Work in progress — functionality is incomplete.
}
\section{Workflow context}{

Use \code{hospital_in_out_dates()} \strong{after}:
\itemize{
\item Linking A&E to inpatient spells (e.g., via \code{link_ae_inpatient()}),
\item Constructing spells (e.g., \code{group_time()} or \code{cip_spells()}),
\item Optional code standardisation (e.g., discharge groups
via \code{lookup_recode()})
}
}

\seealso{
epidm::lookup_recode()

epidm::group_time()

epidm::cip_spells()
}
