% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpatient_codes.R
\name{inpatient_codes}
\alias{inpatient_codes}
\title{Inpatient Codes cleanup}
\usage{
inpatient_codes(
  x,
  field_strings,
  patient_id_vars,
  type = c("icd9", "icd10", "opcs"),
  .forceCopy = FALSE
)
}
\arguments{
\item{x}{a data.frame or data.table containing inpatient data}

\item{field_strings}{a vector or string containing the regex for the the columns}

\item{patient_id_vars}{a vector containing colnames used to identify a patient episode or spell}

\item{type}{a string to denote if the codes are diagnostic or procedural}

\item{.forceCopy}{Logical (default \code{FALSE}).
If \code{FALSE}, the input is converted to a \code{data.table} and modified by
reference.
If \code{TRUE}, the input must already be a \code{data.table}, and the function will
create an explicit copy to avoid modifying the original object.}
}
\value{
a separate table with codes and id in long form
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

When HES/SUS ICD/OPCS codes are provided in wide format
you may want to clean them up into long for easier analysis.
This function helps by reshaping long as a separate table.
Ensuring they're separate allows you to retain source data, and aggregate
appropriately later.
}
\examples{

# Example inpatient dataset
inpatient_test <- data.frame(
  id = c(1053L, 5487L, 8180L),
  spell_id = c("dwPDw", "iSpUq", "qpgk5"),
  primary_diagnosis_code = c("K602", "U071-", "I501"),
  procedure_code = c("H201", "H251", NA),
  procedure_date = as.Date(c("2023-01-01", "2023-01-04", NA))
)

# ICD-10 cleaning example
inpatient_codes(
  x = inpatient_test,
  field_strings = "diagnosis",
  patient_id_vars = c("id", "spell_id"),
  type = "icd10"
)

# OPCS cleaning example
inpatient_codes(
  x = inpatient_test,
  field_strings = c("procedure_code", "procedure_date"),
  patient_id_vars = c("id", "spell_id"),
  type = "opcs"
)

}
