% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm.R
\name{cyclicalweights-ergmTerm}
\alias{cyclicalweights-ergmTerm}
\alias{InitWtErgmTerm.cyclicalweights}
\title{Cyclical weights}
\usage{
# valued: cyclicalweights(twopath="min", combine="max", affect="min")
}
\arguments{
\item{twopath}{the minimum of the constituent dyads ( \code{"min"} ) or their geometric mean
( \code{"geomean"} )}

\item{combine}{the maximum of the
2-path strengths ( \code{"max"} ) or their sum ( \code{"sum"} )}

\item{affected}{the minimum of the focus dyad and the
combined strength of the two paths ( \code{"min"} ) or their
geometric mean ( \code{"geomean"} )}
}
\description{
This statistic implements the cyclical weights
statistic, like that defined by \insertCite{Kr12e;textual}{ergm}, Equation 13,
but with the focus dyad being \eqn{y_{j,i}} rather than
\eqn{y_{i,j}} . For each option,
the first (and the default) is more stable but also more
conservative, while the second is more sensitive but more likely
to induce a multimodal distribution of networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "cyclicalweights", "subsection")}
}
\concept{directed}
\concept{nonnegative}
\concept{undirected}
