% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_sari_positivity.R
\name{plot_sari_positivity}
\alias{plot_sari_positivity}
\title{Plot ERVISS SARI positivity data}
\usage{
plot_sari_positivity(data, date_breaks = "2 weeks", date_format = "\%b \%Y")
}
\arguments{
\item{data}{A data.table or data.frame containing SARI positivity data, typically
output from \code{\link{get_sari_positivity}}. Must contain columns: date, value,
pathogen, countryname.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}
}
\value{
A ggplot2 object
}
\description{
Creates a ggplot2 visualization of SARI positivity data, with facets
by country and colored by pathogen.
}
\examples{
\donttest{
data <- get_sari_positivity(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-06-30"),
  pathogen = "Influenza",
  indicator = "positivity"
)
plot_sari_positivity(data, date_breaks = "1 month")
}
}
