% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any_void.R
\name{any_void}
\alias{any_void}
\title{any_void(): Check if Any Value is Void (NA / NULL / "")}
\usage{
any_void(x, include_na = TRUE, include_null = TRUE, include_empty_str = TRUE)
}
\arguments{
\item{x}{A vector or list to evaluate.}

\item{include_na}{Logical. Consider \code{NA} as void. Default: TRUE.}

\item{include_null}{Logical. Consider \code{NULL} as void. Default: TRUE.}

\item{include_empty_str}{Logical. Consider \code{""} as void. Default: TRUE.}
}
\value{
A single logical value:
\itemize{
\item \code{TRUE} if any void values are present.
\item \code{FALSE} otherwise.
\item For \code{NULL} input, returns \code{TRUE} if \code{include_null = TRUE}, else \code{FALSE}.
}
}
\description{
Test whether any element in a vector or list is considered "void".
Void values include \code{NA}, \code{NULL}, and empty strings (\code{""}), and
you can customize which ones to consider.
}
\examples{
any_void(c("a", "", NA))                # TRUE
any_void(list("x", NULL, "y"))          # TRUE
any_void(c("a", "b", "c"))              # FALSE
any_void(NULL)                          # TRUE
any_void("", include_empty_str = FALSE) # FALSE
}
