% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{check_pkg}
\alias{check_pkg}
\title{Check Package Installation Status}
\usage{
check_pkg(
  pkg = NULL,
  source = c("CRAN", "GitHub", "Bioconductor"),
  auto_install = TRUE,
  ...
)
}
\arguments{
\item{pkg}{Character vector. Package names or GitHub repos (e.g., "user/repo").}

\item{source}{Character. Package source: "CRAN", "GitHub", or "Bioconductor".}

\item{auto_install}{Logical. If TRUE (default), install missing packages automatically.}

\item{...}{Additional arguments passed to \code{inst_pkg()}.}
}
\value{
A tibble with columns: \code{package}, \code{name}, \code{installed}, \code{source}.
}
\description{
Check whether packages are installed and optionally install missing ones.
Internally calls \code{inst_pkg()} for auto-installation.
}
\examples{
# Check if ggplot2 is installed (will install if missing):
check_pkg("ggplot2", source = "CRAN")

# Check without auto-install:
check_pkg("r-lib/devtools", source = "GitHub", auto_install = FALSE)

}
