% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{set_mirror}
\alias{set_mirror}
\title{Set CRAN/Bioconductor Mirrors}
\usage{
set_mirror(repo = c("all", "cran", "bioc"), mirror = "tuna")
}
\arguments{
\item{repo}{Character. Repository type: "cran", "bioc", or "all" (default: "all").}

\item{mirror}{Character. Predefined mirror name (default: "tuna").}
}
\value{
Previous mirror settings (invisibly).
}
\description{
Configure CRAN and/or Bioconductor mirrors for faster package installation.
Once set, all package management functions (\code{inst_pkg}, \code{update_pkg},
etc.) will respect these mirror settings.
}
\details{
Available CRAN mirrors:
\itemize{
\item \strong{official}: R Project cloud server
\item \strong{rstudio}: RStudio CRAN mirror
\item \strong{tuna}: Tsinghua University (China)
\item \strong{ustc}: USTC (China)
\item \strong{aliyun}: Alibaba Cloud (China)
\item \strong{sjtu}: Shanghai Jiao Tong University (China)
\item \strong{pku}: Peking University (China)
\item \strong{hku}: Hong Kong University
\item \strong{westlake}: Westlake University (China)
\item \strong{nju}: Nanjing University (China)
\item \strong{sustech}: SUSTech (China)
}

Available Bioconductor mirrors:
\itemize{
\item \strong{official}: Bioconductor official server
\item \strong{tuna}: Tsinghua University (China)
\item \strong{ustc}: USTC (China)
\item \strong{westlake}: Westlake University (China)
\item \strong{nju}: Nanjing University (China)
}
}
\examples{
\dontrun{
# Set all mirrors to tuna (default):
set_mirror()

# Set only CRAN mirror:
set_mirror("cran", "westlake")

# Set only Bioconductor mirror:
set_mirror("bioc", "ustc")

# Check current settings:
getOption("repos")
getOption("BioC_mirror")
}

}
