% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdqlmForecast.R
\name{exdqlmForecast}
\alias{exdqlmForecast}
\title{k-step-ahead quantile forecasts}
\usage{
exdqlmForecast(
  start.t,
  k,
  m1,
  fFF = NULL,
  fGG = NULL,
  plot = TRUE,
  add = FALSE,
  cols = c("purple", "magenta"),
  cr.percent = 0.95
)
}
\arguments{
\item{start.t}{Integer index at which forecasts start (must be within the span of the fitted model in \code{m1}).}

\item{k}{Integer; number of steps ahead to forecast.}

\item{m1}{A fitted exDQLM model object, typically returned by \code{\link[=exdqlmISVB]{exdqlmISVB()}} or \code{\link[=exdqlmMCMC]{exdqlmMCMC()}}.}

\item{fFF}{Optional state vector(s) for the forecast steps. A numeric matrix with
\eqn{p} rows and either 1 column (non–time-varying) or \code{k} columns (time-varying).
Its dimension must match the fitted model in \code{m1}.}

\item{fGG}{Optional evolution matrix/matrices for the forecast steps. Either a numeric
\eqn{p \times p} matrix (non–time-varying) or a \eqn{p \times p \times k} array (time-varying).
Its dimensions must match the fitted model in \code{m1}.}

\item{plot}{Logical; if \code{TRUE}, plot filtered and forecast quantiles with
equal–tailed credible intervals. Default \code{TRUE}.}

\item{add}{Logical; if \code{TRUE}, add the forecasted quantiles to the current plot.
Default \code{FALSE}.}

\item{cols}{Character vector of length 2 giving the colors for filtered and forecasted
quantiles respectively. Default \code{c("purple","magenta")}.}

\item{cr.percent}{Numeric in \code{(0, 1)}; the probability mass for the credible
intervals (e.g., \code{0.95}). Default \code{0.95}.}
}
\value{
A object of class "\code{exdqlmForecast}" containing the following:
\itemize{
\item \code{start.t} Integer index at which forecasts start (within the span of the fitted model in \code{m1}).
\item \code{k} Integer; number of steps ahead forecasted.
\item \code{m1} A fitted exDQLM model object, typically returned by \code{\link[=exdqlmISVB]{exdqlmISVB()}} or \code{\link[=exdqlmMCMC]{exdqlmMCMC()}}.
\item \code{cr.percent} Numeric in \code{(0, 1)}; the probability mass for the credible
intervals (e.g., \code{0.95}).
\item \code{fa} Forecast state mean vectors (\eqn{p \times k} matrix).
\item \code{fR} Forecast state covariance matrices (\eqn{p \times p \times k} array).
\item \code{ff} Forecast quantile means (length-\code{k} numeric).
\item \code{fQ} Forecast quantile variances (length-\code{k} numeric).
}
}
\description{
Computes filtered and \code{k}-step-ahead forecast quantiles from a fitted
dynamic quantile model and optionally adds them to an existing plot.
}
\examples{
\donttest{
 # Toy example; keep small and fast
 y <- scIVTmag[1:100]
 model <- polytrendMod(1, stats::quantile(y, 0.85), 10)
 M0 <- exdqlmISVB(y, p0 = 0.85, model, df = c(0.98), dim.df = c(1),
                  gam.init = -3.5, sig.init = 15)
 exdqlmForecast(start.t = 90, k = 10, m1 = M0)
}

}
