% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_etc.R
\name{+.exdqlm}
\alias{+.exdqlm}
\title{Addition for \code{exdqlm} objects}
\usage{
\method{+}{exdqlm}(m1, m2)
}
\arguments{
\item{m1}{object of class "\code{exdqlm}" containing the first model to be combined.}

\item{m2}{object of class "\code{exdqlm}" containing the second model to be combined.}
}
\value{
A object of class "\code{exdqlm}" containing the new combined state space model components:
\itemize{
\item FF - Observational vector.
\item GG - Evolution matrix.
\item m0 - Prior mean of the state vector.
\item C0 - Prior covariance of the state vector.
}
}
\description{
Combines two state space blocks into a single state space model for an exDQLM.
}
\examples{
trend.comp = polytrendMod(2,rep(0,2),10*diag(2))
seas.comp = seasMod(365,c(1,2,4),C0=10*diag(6))
model = trend.comp + seas.comp

}
