% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exal.r
\name{rexal}
\alias{rexal}
\title{Random Sample Generation for the exAL Distribution}
\usage{
rexal(n, p0 = 0.5, mu = 0, sigma = 1, gamma = 0)
}
\arguments{
\item{n}{Positive integer number of samples to draw (scalar).}

\item{p0}{Probability level used in the quantile parametrization. Scalar in (0, 1). Default \code{0.5}.}

\item{mu}{Location parameter (scalar). Default \code{0}.}

\item{sigma}{Scale parameter (scalar, strictly positive). Default \code{1}.}

\item{gamma}{Skewness parameter controlling asymmetry (scalar). Must be within valid bounds implied by \code{p0}. Default \code{0}.}
}
\value{
Numeric vector of length \code{n}.
}
\description{
Random Sample Generation for the exAL Distribution
}
\examples{
set.seed(1); length(rexal(10))
rexal(3, p0 = 0.5, mu = c(-1, 0, 1))

}
