% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{tidy.mdl_df}
\alias{tidy.mdl_df}
\alias{coef.mdl_df}
\alias{tidy.mdl_ts}
\alias{coef.mdl_ts}
\title{Extract model coefficients from a mable}
\usage{
\method{tidy}{mdl_df}(x, ...)

\method{coef}{mdl_df}(object, ...)

\method{tidy}{mdl_ts}(x, ...)

\method{coef}{mdl_ts}(object, ...)
}
\arguments{
\item{x, object}{A mable.}

\item{...}{Arguments for model methods.}
}
\description{
This function will obtain the coefficients (and associated statistics) for
each model in the mable.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(fable)
library(tsibbledata)

olympic_running \%>\%
  model(lm = TSLM(log(Time) ~ trend())) \%>\% 
  tidy()
\dontshow{\}) # examplesIf}
}
