% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_R}
\alias{qr_R}
\title{Reconstruct the R, matrix from a QR object.}
\usage{
qr_R(qr, rank = NULL, pivot = NULL, complete = NULL)
}
\arguments{
\item{qr}{object representing a QR decomposition. This will typically have come from a previous call to qr.}

\item{rank}{the rank of x as computed by the decomposition.}

\item{pivot}{a vector of length \eqn{p}, specifying the permutation of the columns of \eqn{X} applied during the QR decomposition process. The default is NULL if no pivoting has been applied.}

\item{complete}{logical flag (length 1). Indicates whether the \eqn{R} matrix is to be completed by binding zero-value rows beneath the square upper triangle. If \eqn{r = \mathrm{rank}(X) < p}, then only the reduced \eqn{R \in \mathbb{R}^{r \times p}} matrix is returned.}
}
\value{
returns part or all of \eqn{R}. If complete is TRUE, \eqn{R} has \eqn{n} rows. If complete is FALSE, \eqn{R} has \eqn{p} rows.
}
\description{
returns the \eqn{R} matrix of the full QR decomposition. If \eqn{r = \mathrm{rank}(X) < p}, then only the reduced \eqn{R \in \mathbb{R}^{r \times p}} matrix is returned.
}
\examples{
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p), n, p)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X,
                          tol = sqrt(.Machine$double.eps),
                          pivot = TRUE)

## get the full R matrix
R1 <- qr_R(qr_res$qr, complete = TRUE)

## check that X^TX = R^TR
## get the permutation matrix
P <- qr_pivot2perm(pivot = qr_res$pivot)
max(abs(crossprod(R1 \%*\% P) - crossprod(X)))
max(abs(crossprod(R1) - crossprod(X \%*\% t(P))))

## get the reduced R matrix
R2 <- qr_R(qr_res$qr, qr_res$rank, complete = FALSE)

## check that X^TX = R^TR
## get the permutation matrix
P <- qr_pivot2perm(pivot = qr_res$pivot)
max(abs(crossprod(R2 \%*\% P) - crossprod(X)))
max(abs(crossprod(R2) - crossprod(X \%*\% t(P))))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
