% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_dist.R
\name{cum_haz.dfr_dist}
\alias{cum_haz.dfr_dist}
\title{Method for obtaining the cumulative hazard function of a \code{dfr_dist} object.}
\usage{
\method{cum_haz}{dfr_dist}(x, ...)
}
\arguments{
\item{x}{The object to obtain the cumulative hazard function of.}

\item{...}{Additional arguments to pass into the \code{integrate} function
(only used when no analytical cum_haz_rate is provided).}
}
\value{
A function that computes the cumulative hazard H(t) of the distribution.
It accepts \code{t}, the time at which to compute the cumulative hazard, and
\code{par}, the parameters of the distribution. If \code{par} is \code{NULL}, then the
parameters of the \code{dfr_dist} object \code{x} are used. Finally, it passes any
additional arguments \code{...} to the rate function.
}
\description{
Method for obtaining the cumulative hazard function of a \code{dfr_dist} object.
}
\details{
If the \code{dfr_dist} object has an analytical \code{cum_haz_rate} function, that is
used directly for fast, exact computation. Otherwise, numerical integration
of the hazard function is performed.
}
