% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dfr_loglogistic}
\alias{dfr_loglogistic}
\title{Log-Logistic Distribution (Non-Monotonic Hazard)}
\usage{
dfr_loglogistic(alpha = NULL, beta = NULL)
}
\arguments{
\item{alpha}{Scale parameter. Median lifetime when beta > 1.}

\item{beta}{Shape parameter. Controls hazard shape:
beta <= 1: monotonically decreasing hazard
beta > 1: hazard increases to a peak then decreases}
}
\value{
A \code{dfr_dist} object with analytical rate, cumulative hazard,
and score function.
}
\description{
Creates a DFR distribution with log-logistic hazard function.
The log-logistic has a non-monotonic hazard that increases then decreases,
useful for modeling processes with an initial risk that diminishes.
}
\details{
The log-logistic distribution has:
\itemize{
\item Hazard: \eqn{h(t) = \frac{(\beta/\alpha)(t/\alpha)^{\beta-1}}{1 + (t/\alpha)^\beta}}
\item Cumulative hazard: \eqn{H(t) = \log(1 + (t/\alpha)^\beta)}
\item Survival: \eqn{S(t) = \frac{1}{1 + (t/\alpha)^\beta}}
\item Median: \eqn{\alpha} (when beta > 1)
}
}
\section{Reliability Interpretation}{

The log-logistic is useful when:
\itemize{
\item Initial failures decrease after screening period
\item Risk peaks early then declines (therapy response)
\item Hazard is not monotonic throughout lifetime
}

The cumulative hazard has a closed form and is provided analytically.
}

\examples{
# Component with peak hazard around t = alpha
comp <- dfr_loglogistic(alpha = 1000, beta = 2)

# Non-monotonic hazard
h <- hazard(comp)
h(500)   # increasing phase
h(1000)  # near peak
h(2000)  # decreasing phase

# Survival function
S <- surv(comp)
S(1000)  # 50\% survival at median (alpha)

}
