% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_dist.R
\name{fit.dfr_dist}
\alias{fit.dfr_dist}
\title{MLE solver for dfr_dist objects}
\usage{
\method{fit}{dfr_dist}(object, ...)
}
\arguments{
\item{object}{A \code{dfr_dist} object}

\item{...}{Additional arguments passed to the log-likelihood, score, and
Hessian constructors (e.g., integration parameters for cum_haz)}
}
\value{
A solver function that accepts:
\itemize{
\item \code{df}: Data frame with observation times and censoring indicators
\item \code{par}: Initial parameter values (uses object's params if NULL)
\item \code{method}: Optimization method (default "BFGS")
\item \code{control}: Control parameters for optim()
\item \code{...}: Additional arguments passed to likelihood functions
}
}
\description{
Returns a solver function that fits a dfr_dist model to survival data
using maximum likelihood estimation. The solver uses gradient-based
optimization (BFGS by default) with analytical or numerical gradients.
}
\details{
The solver returns a \code{fisher_mle} object (from likelihood.model) containing:
\itemize{
\item Parameter estimates
\item Log-likelihood value at MLE
\item Variance-covariance matrix (from Hessian)
\item Convergence status
}

Use methods like \code{coef()}, \code{vcov()}, \code{confint()}, \code{summary()} on the result.
}
\examples{
\donttest{
# Exponential distribution
exp_dist <- dfr_dist(
  rate = function(t, par, ...) rep(par[1], length(t)),
  par = c(lambda = 1)
)

# Simulate data
set.seed(42)
df <- data.frame(t = rexp(100, rate = 2), delta = 1)

# Fit model
solver <- fit(exp_dist)
result <- solver(df, par = c(1))
summary(result)
confint(result)
}

}
