% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_extent}
\alias{geo_extent}
\title{Compute bounding boxes for each feature in an sf object}
\usage{
geo_extent(x, crs = 4326)
}
\arguments{
\item{x}{An \code{sf} object (POLYGON or MULTIPOLYGON) for which to compute bounding boxes.}

\item{crs}{Numeric, Code of the target CRS. Default is \code{4326}.}
}
\value{
A \code{data.frame} where each row corresponds to a feature's bounding box,
with columns \code{left}, \code{bottom}, \code{right}, \code{top}.
}
\description{
This internal helper computes the bounding box (\code{left}, \code{bottom}, \code{right}, \code{top})
for each feature in an \code{sf} object.
}
\details{
\itemize{
\item The function first validates the input with \code{\link[=geo_object_check]{geo_object_check()}}.
\item Transforms the object to the target CRS before computing bounding boxes.
\item CRS and units are inherited from the input \code{sf} object.
}
}
\keyword{internal}
