% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{RoMFDI}
\alias{RoMFDI}
\title{Robust Multivariate Functional Data Imputation (RoMFDI)}
\usage{
RoMFDI(
  mfdobj,
  method_pca = "ROBPCA",
  fev = 0.999,
  n_dataset = 3,
  update = TRUE,
  niter_update = 10,
  alpha = 0.8
)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class mfd.}

\item{method_pca}{The method used in \code{rpca_mfd} to perform
robust multivariate functional principal component analysis (RoMFPCA).
See \code{\link{rpca_mfd}}.
Default is \code{"ROBPCA"}.}

\item{fev}{Number between 0 and 1 denoting the proportion
of variability that must be explained by the
principal components to be selected for dimension reduction after
applying RoMFPCA on the observed components to impute the missing ones.
Default is 0.999.}

\item{n_dataset}{To take into account the increased noise due to single imputation,
the proposed RoMFDI allows multiple imputation.
Due to the presence of the stochastic component in the imputation,
it is worth explicitly noting that the imputed data set
is not deterministically assigned.
Therefore, by performing several times the RoMFDI in the
imputation step of the
RoMFCC implementation, the corresponding multiple estimated
RoMFPCA models could
be combined by averaging the robustly estimated covariance functions,
thus performing a
multiple imputation strategy as suggested by Van Ginkel et al. (2007).
Default is 3.}

\item{update}{The RoMFDI performs sequential imputation of missing functional
components.
If TRUE, Robust Multivariate Functional
Principal Component Analysis (RoMFPCA) \code{niter_update} is updated times
during the algorithm.
If FALSE, the RoMFPCA used for imputation is always the same, i.e.,
the one performed on the original data sets containing only
the observations with no missing functional components.
Default is TRUE.}

\item{niter_update}{The number of times the RoMFPCA is updated during the algorithm.
It applies only if update is TRUE. Default value is 10.}

\item{alpha}{This parameter measures the fraction of outliers the
RoMFPCA algorithm should resist and is used only
if \code{method_pca} is \code{"ROBPCA"}.
Default is 0.8.}
}
\value{
A list with \code{n_dataset} elements.
Each element is an \code{mfd} object containing \code{mfdobj} with
stochastic imputation of the missing components.
}
\description{
It performs Robust Multivariate Functional Data Imputation (RoMFDI)
as in Capezza et al. (2024).
}
\examples{
\donttest{
library(funcharts)
mfdobj <- get_mfd_list(air[1:3], grid = 1:24, n_basis = 13, lambda = 1e-2)
out <- functional_filter(mfdobj, bivariate = FALSE)
mfdobj_imp <- RoMFDI(out$mfdobj, n_dataset = 1, update = FALSE)
}

}
\references{
Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Chart.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.

Van Ginkel, J. R., Van der Ark, L. A., Sijtsma, K., and Vermunt, J. K.
(2007). Two-way
imputation: a Bayesian method for estimating missing scores in tests
and questionnaires, and an accurate approximation.
\emph{Computational Statistics & Data Analysis}, 51(8):4013–-4027.
}
