% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_api_key.R
\name{anthropic_api_key}
\alias{anthropic_api_key}
\title{Install an ANTHROPIC API KEY in Your \code{.Renviron} File for Repeated Use}
\usage{
anthropic_api_key(key, overwrite = FALSE, install = FALSE)
}
\arguments{
\item{key}{The API key provided to you from Anthropic formatted in quotes. A key can be acquired at \url{https://console.anthropic.com/settings/keys}}

\item{overwrite}{If this is set to TRUE, it will overwrite an existing ANTHROPIC_API_KEY that you already have in your \code{.Renviron} file.}

\item{install}{if TRUE, will install the key in your \code{.Renviron} file for use in future sessions.  Defaults to FALSE.}
}
\value{
No return value, called for side effects.
}
\description{
This function will add your Anthropic API key to your \code{.Renviron} file so it can be called securely without being stored
in your code. After you have installed your key, it can be called any time by typing \code{Sys.getenv("ANTHROPIC_API_KEY")} and will be
automatically called in package functions. If you do not have an \code{.Renviron} file, the function will create one for you.
If you already have an \code{.Renviron} file, the function will append the key to your existing file, while making a backup of your
original file for disaster recovery purposes.
}
\examples{

\dontrun{
anthropic_api_key("111111abc", install = TRUE)
# First time, reload your environment so you can use the key without restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("ANTHROPIC_API_KEY")
}

\dontrun{
# If you need to overwrite an existing key:
anthropic_api_key("111111abc", overwrite = TRUE, install = TRUE)
# First time, reload your environment so you can use the key without restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("ANTHROPIC_API_KEY")
}
}
