% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl3dplotly.R
\name{qtl3dplotly}
\alias{qtl3dplotly}
\title{3D QTL plot}
\usage{
qtl3dplotly(
  d,
  chrlen = gap::hg19,
  zmax = 300,
  qtl.id = "SNPid:",
  qtl.prefix = "QTL:",
  qtl.gene = "Gene:",
  target.type = "Protein",
  TSS = FALSE,
  xlab = "QTL position",
  ylab = "Gene position",
  ...
)
}
\arguments{
\item{d}{Data in qtl2d() format.}

\item{chrlen}{Lengths of chromosomes for specific build: hg18, hg19, hg38.}

\item{zmax}{Maximum value (e.g., -log10p) to truncate, above which they would be set to this value.}

\item{qtl.id}{QTL id.}

\item{qtl.prefix}{QTL prefix.}

\item{qtl.gene}{QTL target gene.}

\item{target.type}{Type of target, e.g., protein.}

\item{TSS}{to use TSS when TRUE.}

\item{xlab}{X-axis title.}

\item{ylab}{Y-axis title.}

\item{...}{Additional arguments, e.g., to qtl2dplot().}
}
\value{
A plotly figure.
}
\description{
3D QTL plot
}
\examples{
\dontrun{
suppressMessages(library(dplyr))
INF <- Sys.getenv("INF")
d <- read.csv(file.path(INF,"work","INF1.merge.cis.vs.trans"),as.is=TRUE) \%>\%
     mutate(log10p=-log10p)
r <- qtl3dplotly(d,zmax=300)
htmlwidgets::saveWidget(r,file=file.path(INF,"INF1.qtl3dplotly.html"))
r
}
}
