% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{hCOM}
\alias{hCOM}
\title{Finds the horizontal (x axis, i.e. the axis vertical to the cross-sections) position of the center of mass (COM) of the volume. Experimental; only valid for "raw" gdi results with segment volumes approximated as elliptical prisms, or for manually supplied segment COMs. COM is calculated as a weighted mean of all segment COMs, with the segment mass as the weighting factor.}
\usage{
hCOM(
  x,
  volumes = NULL,
  align = "h",
  subtract = NULL,
  densities = NULL,
  scale = 1
)
}
\arguments{
\item{x}{Either a data frame that is the output of gdi(..., return="all"), or a numeric vector of horizontal segment COM positions.}

\item{volumes}{An optional separate vector of volumes, required if x is not a data.frame containing volumes.}

\item{align}{alignment of the silhouette, if "h" (default) the silhouette is assumed to be horizontally aligned, if any other value (e.g. "v") then the silhouette is assumed to be vertically aligned.}

\item{subtract}{An optional separate vector of volumes, with length equal to the length or nrow() of x, to be subtracted from the volumes for the COM calculation.}

\item{densities}{An optional vector of segment densities, with length equal to the length or nrow() of x, to be multiplied with the volumes for the COM calculation. If both subtract and densities are supplied, the density is applied only to the "residual" volume that is left after subtraction.}

\item{scale}{Optional scale value (number of pixels to chosen unit of measurement)}
}
\value{
An object of class numeric() containing the x coordinate of the center of mass of the shape, in pixels (or chosen units, if manually calculated)
}
\description{
Finds the horizontal (x axis, i.e. the axis vertical to the cross-sections) position of the center of mass (COM) of the volume. Experimental; only valid for "raw" gdi results with segment volumes approximated as elliptical prisms, or for manually supplied segment COMs. COM is calculated as a weighted mean of all segment COMs, with the segment mass as the weighting factor.
}
\examples{
fdir <- system.file(package="gdi")
measuresil(file.path(fdir,"exdata","lat.png"), return="all")->lat_
measuresil(file.path(fdir,"exdata","dors.png"), return="all")->dors_
gdi(lat_, dors_, return="all")->gdiresults
hCOM(gdiresults)
}
