% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsoid.R
\name{ellipsoid_params}
\alias{ellipsoid_params}
\alias{ellipsoid_circle}
\alias{ellipsoid_latitudes}
\alias{ellipsoid_latitudes_inv}
\alias{ellipsoid_curvature}
\title{WGS84 Ellipsoid parameters and calculations}
\usage{
ellipsoid_params()

ellipsoid_circle(lat)

ellipsoid_latitudes(lat)

ellipsoid_latitudes_inv(lat, type)

ellipsoid_curvature(lat)
}
\arguments{
\item{lat}{Numeric vector of geographic (geodetic) latitudes in decimal degrees.}

\item{type}{Character string specifying the type of auxiliary latitude for
inverse conversion. One of: "parametric", "geocentric", "rectifying",
"authalic", "conformal", "isometric".}
}
\value{
\itemize{
\item \code{ellipsoid_params()}: Named list with WGS84 parameters:
\itemize{
\item \code{a}: Equatorial radius (semi-major axis) in meters
\item \code{f}: Flattening
\item \code{b}: Polar radius (semi-minor axis) in meters
\item \code{e2}: First eccentricity squared
\item \code{ep2}: Second eccentricity squared
\item \code{n}: Third flattening
\item \code{area}: Surface area in square meters
\item \code{volume}: Volume in cubic meters
}
\item \code{ellipsoid_circle()}: Data frame with columns:
\itemize{
\item \code{lat}: Input latitude
\item \code{radius}: Radius of the circle of latitude in meters
\item \code{quarter_meridian}: Distance from equator to pole along a meridian
\item \code{meridian_distance}: Distance from equator to the given latitude
}
\item \code{ellipsoid_latitudes()}: Data frame with auxiliary latitudes:
\itemize{
\item \code{lat}: Input geographic latitude
\item \code{parametric}: Parametric (reduced) latitude
\item \code{geocentric}: Geocentric latitude
\item \code{rectifying}: Rectifying latitude
\item \code{authalic}: Authalic latitude
\item \code{conformal}: Conformal latitude
\item \code{isometric}: Isometric latitude
}
\item \code{ellipsoid_latitudes_inv()}: Data frame with:
\itemize{
\item \code{input}: Input auxiliary latitude
\item \code{geographic}: Corresponding geographic latitude
}
\item \code{ellipsoid_curvature()}: Data frame with radii of curvature:
\itemize{
\item \code{lat}: Input latitude
\item \code{meridional}: Meridional radius of curvature (M)
\item \code{transverse}: Transverse radius of curvature (N)
}
}
}
\description{
Access WGS84 ellipsoid parameters and perform ellipsoid-related calculations
including auxiliary latitudes, radii of curvature, and meridian distances.
}
\details{
The WGS84 ellipsoid is the reference surface used by GPS and most modern
mapping systems. It is defined by:
\itemize{
\item Equatorial radius: 6,378,137 m
\item Flattening: 1/298.257223563
}

\strong{Auxiliary latitudes} are different ways of measuring latitude that are
useful in various map projections:
\itemize{
\item \strong{Parametric}: Used in ellipsoid parameterization
\item \strong{Geocentric}: Angle from center of ellipsoid
\item \strong{Rectifying}: Preserves distances along meridians
\item \strong{Authalic}: Preserves areas
\item \strong{Conformal}: Preserves angles/shapes
\item \strong{Isometric}: Used in Mercator projection
}
}
\examples{
# WGS84 parameters
ellipsoid_params()

# Radius at different latitudes
ellipsoid_circle(c(0, 30, 45, 60, 90))

# Compare auxiliary latitudes
ellipsoid_latitudes(c(0, 30, 45, 60, 90))

# Radii of curvature
ellipsoid_curvature(c(0, 45, 90))
}
