% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_position.R
\name{legend_inside}
\alias{legend_inside}
\title{Place Legend Inside the Plot Area}
\usage{
legend_inside(
  x = NULL,
  y = NULL,
  position = NULL,
  just = NULL,
  background = "white",
  border = NA,
  padding = 0.2
)
}
\arguments{
\item{x}{Numeric x-coordinate in normalized 0-1 space, where 0 is left
and 1 is right. Ignored if \code{position} is specified.}

\item{y}{Numeric y-coordinate in normalized 0-1 space, where 0 is bottom
and 1 is top. Ignored if \code{position} is specified.}

\item{position}{Character shortcut for common positions. One of
\code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"left"},
\code{"center"}, \code{"right"}, \code{"bottomleft"}, \code{"bottom"},
\code{"bottomright"}. If specified, overrides \code{x} and \code{y}.}

\item{just}{Justification of legend relative to the anchor point. Either a
character vector of length 2 (horizontal, vertical) or a single value.
Common values: \code{c("left", "top")}, \code{c("right", "bottom")},
\code{"center"}. If \code{NULL}, automatically determined based on position.}

\item{background}{Background fill color for the legend. Default is
\code{"white"}.}

\item{border}{Border color for the legend box. Default is \code{NA} (no border).}

\item{padding}{Padding around legend content in cm. Default is \code{0.2}.}
}
\value{
A ggplot2 theme object that can be added to a plot.
}
\description{
Position the legend inside the plot panel at specified coordinates or using
convenient position shortcuts like \code{"topright"} or \code{"bottomleft"}.
}
\examples{
library(ggplot2)

# Using position shortcuts (recommended)
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_inside(position = "topright")

ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_inside(position = "bottomleft")

# Using coordinates
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_inside(x = 0.95, y = 0.95, just = c("right", "top"))

# Custom background and border
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_inside(position = "topright", background = "grey95", border = "grey50")

}
\seealso{
\code{\link{legend_left}}, \code{\link{legend_right}},
\code{\link{legend_top}}, \code{\link{legend_bottom}}
}
