% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_can_repeat}
\alias{ggml_can_repeat}
\title{Check If Tensor Can Be Repeated}
\usage{
ggml_can_repeat(a, b)
}
\arguments{
\item{a}{Source tensor (smaller)}

\item{b}{Target tensor (larger or same size)}
}
\value{
Logical indicating if a can be repeated to match b
}
\description{
Check if tensor \code{a} can be repeated (broadcast) to match tensor \code{b}.
Used for broadcasting operations.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
b <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 8)
ggml_can_repeat(a, b)  # TRUE - a can broadcast along dim 1
ggml_free(ctx)
}
}
\seealso{
Other tensor_layout: 
\code{\link{ggml_are_same_stride}()},
\code{\link{ggml_count_equal}()},
\code{\link{ggml_is_contiguous_0}()},
\code{\link{ggml_is_contiguous_1}()},
\code{\link{ggml_is_contiguous_2}()},
\code{\link{ggml_is_contiguous_channels}()},
\code{\link{ggml_is_contiguous_rows}()},
\code{\link{ggml_is_contiguously_allocated}()}
}
\concept{tensor_layout}
