% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_rope_ext}
\alias{ggml_rope_ext}
\title{Extended RoPE with Frequency Scaling (Graph)}
\usage{
ggml_rope_ext(
  ctx,
  a,
  b,
  c = NULL,
  n_dims,
  mode = 0L,
  n_ctx_orig = 0L,
  freq_base = 10000,
  freq_scale = 1,
  ext_factor = 0,
  attn_factor = 1,
  beta_fast = 32,
  beta_slow = 1
)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{b}{Position tensor (int32)}

\item{c}{Optional frequency factors tensor (NULL for default)}

\item{n_dims}{Number of dimensions to apply rotation to}

\item{mode}{RoPE mode}

\item{n_ctx_orig}{Original context length the model was trained on}

\item{freq_base}{Base frequency for RoPE (default 10000 for most models)}

\item{freq_scale}{Frequency scale factor (1.0 = no scaling)}

\item{ext_factor}{YaRN extension factor (0.0 to disable)}

\item{attn_factor}{Attention scale factor (typically 1.0)}

\item{beta_fast}{YaRN parameter for fast dimensions}

\item{beta_slow}{YaRN parameter for slow dimensions}
}
\value{
Tensor with extended RoPE applied
}
\description{
Creates a graph node for extended RoPE with frequency scaling parameters.
Supports context extension techniques like YaRN, Linear Scaling, etc.
}
\details{
This extended version supports various context extension techniques:

- **Linear Scaling**: Set freq_scale = original_ctx / new_ctx
- **YaRN**: Set ext_factor > 0 with appropriate beta_fast/beta_slow
- **NTK-aware**: Adjust freq_base for NTK-style scaling

Common freq_base values:
- LLaMA 1/2: 10000
- LLaMA 3: 500000
- Mistral: 10000
- Phi-3: 10000
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
q <- ggml_new_tensor_4d(ctx, GGML_TYPE_F32, 64, 8, 32, 1)
ggml_set_f32(q, rnorm(64 * 8 * 32))
pos <- ggml_new_tensor_1d(ctx, GGML_TYPE_I32, 32)
ggml_set_i32(pos, 0:31)
# Standard RoPE with default freq_base
q_rope <- ggml_rope_ext(ctx, q, pos, NULL,
                        n_dims = 64, mode = 0L,
                        n_ctx_orig = 4096,
                        freq_base = 10000, freq_scale = 1.0,
                        ext_factor = 0.0, attn_factor = 1.0,
                        beta_fast = 32, beta_slow = 1)
graph <- ggml_build_forward_expand(ctx, q_rope)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
