% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_softplus}
\alias{ggml_softplus}
\title{Softplus Activation (Graph)}
\usage{
ggml_softplus(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the Softplus operation
}
\description{
Creates a graph node for Softplus activation.
Softplus(x) = log(1 + exp(x)).
A smooth approximation of ReLU.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -1, 0, 1, 2))
r <- ggml_softplus(ctx, a)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)
ggml_free(ctx)
}
}
