% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_model.R
\name{ggml_save_model}
\alias{ggml_save_model}
\title{Save a Full Model (Architecture + Weights)}
\usage{
ggml_save_model(model, path)
}
\arguments{
\item{model}{A trained \code{ggml_sequential_model} or
\code{ggml_functional_model}.}

\item{path}{File path (typically \code{.rds}).}
}
\value{
The model (invisibly).
}
\description{
Saves both the architecture and trained weights of a model to an RDS file.
Unlike \code{ggml_save_weights()}, which requires the model to be manually
reconstructed before loading, \code{ggml_save_model()} saves everything
needed to restore the model with a single call to \code{ggml_load_model()}.
}
\section{Supported model types}{

\itemize{
  \item \code{ggml_sequential_model} — input shape, layer configs, trained
    weights, and compilation settings are all saved.
  \item \code{ggml_functional_model} — input/output node graphs (pure R
    lists, no ggml pointers) and trained \code{node_weights} are saved.
}
}

\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_dense(16L, activation = "relu", input_shape = 4L) |>
  ggml_layer_dense(2L,  activation = "softmax")
model <- ggml_compile(model, optimizer = "adam",
                       loss = "categorical_crossentropy")
x <- matrix(runif(64 * 4), 64, 4)
y <- matrix(c(rep(c(1,0), 32), rep(c(0,1), 32)), 64, 2)
model <- ggml_fit(model, x, y, epochs = 1L, batch_size = 32L, verbose = 0L)
tmp <- tempfile(fileext = ".rds")
ggml_save_model(model, tmp)
model2 <- ggml_load_model(tmp)
}
}
