% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_sub}
\alias{ggml_sub}
\title{Element-wise Subtraction (Graph)}
\usage{
ggml_sub(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First tensor}

\item{b}{Second tensor (same shape as a)}
}
\value{
Tensor representing the subtraction operation (a - b)
}
\description{
Creates a graph node for element-wise subtraction.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(5, 4, 3, 2, 1))
ggml_set_f32(b, c(1, 1, 1, 1, 1))
result <- ggml_sub(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
}
