% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_thread.R
\name{gm_threads}
\alias{gm_threads}
\title{Get a list of threads}
\usage{
gm_threads(
  search = NULL,
  num_results = NULL,
  page_token = NULL,
  label_ids = NULL,
  include_spam_trash = NULL,
  user_id = "me"
)
}
\arguments{
\item{search}{query to use, same format as gmail search box.}

\item{num_results}{the number of results to return.}

\item{page_token}{retrieve a specific page of results}

\item{label_ids}{restrict search to given labels}

\item{include_spam_trash}{boolean whether to include the spam and trash folders in the search}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Get a list of threads possibly matching a given query string.
}
\examples{
\dontrun{
my_threads <- gm_threads()

first_10_threads <- gm_threads(10)
}
}
\references{
\url{https://developers.google.com/gmail/api/reference/rest/v1/users.threads/list}
}
\seealso{
Other thread: 
\code{\link{gm_delete_thread}()},
\code{\link{gm_modify_thread}()},
\code{\link{gm_thread}()},
\code{\link{gm_trash_thread}()},
\code{\link{gm_untrash_thread}()}
}
\concept{thread}
