% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_pga_leaderboards}
\alias{load_pga_leaderboards}
\title{Load PGA Leaderboards}
\usage{
load_pga_leaderboards(years, tournaments = NULL, tour = "pga", dir = NULL)
}
\arguments{
\item{years}{Numeric vector. Year(s) to load (e.g., 2025 or 2023:2025).}

\item{tournaments}{Character vector. Optional tournament event IDs or names
to filter. If NULL, loads all tournaments.}

\item{tour}{Character. Tour type, default "pga".}

\item{dir}{Character. Optional directory to save CSV files.}
}
\value{
A tibble with leaderboard data.
}
\description{
Loads tournament leaderboard data for specified year(s) and tournament(s).
This is similar to nflfastR's data loading pattern.
}
\examples{
\donttest{
# Load specific tournament
masters <- load_pga_leaderboards(2025, tournaments = "401703504")

# Load all 2025 tournaments
all_2025 <- load_pga_leaderboards(2025)
}
}
