% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grangersearch.R
\name{tidy.granger_result}
\alias{tidy.granger_result}
\title{Tidy a granger_result Object}
\usage{
\method{tidy}{granger_result}(x, ...)
}
\arguments{
\item{x}{A \code{granger_result} object.}

\item{...}{Additional arguments (ignored).}
}
\value{
A tibble with columns:
\describe{
\item{direction}{Character. The causal direction tested (e.g., "x -> y").}
\item{cause}{Character. The name of the potential cause variable.}
\item{effect}{Character. The name of the potential effect variable.}
\item{statistic}{Numeric. The F-test statistic.}
\item{p.value}{Numeric. The p-value of the test.}
\item{significant}{Logical. Whether the result is significant at the alpha level.}
}
}
\description{
Returns a tibble with one row per direction tested, containing test results.
Compatible with the broom package conventions.
}
\examples{
set.seed(123)
x <- cumsum(rnorm(100))
y <- c(0, x[1:99]) + rnorm(100, sd = 0.5)
result <- granger_causality_test(x = x, y = y)
tidy(result)

}
