% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{derivatives}
\alias{derivatives}
\alias{derivatives.default}
\alias{derivatives.gamm}
\alias{derivatives.gam}
\title{Derivatives of estimated smooths via finite differences}
\usage{
derivatives(object, ...)

\method{derivatives}{default}(object, ...)

\method{derivatives}{gamm}(object, ...)

\method{derivatives}{gam}(
  object,
  select = NULL,
  term = deprecated(),
  data = newdata,
  order = 1L,
  type = c("forward", "backward", "central"),
  n = 100,
  eps = 1e-07,
  interval = c("confidence", "simultaneous"),
  n_sim = 10000,
  level = 0.95,
  unconditional = FALSE,
  frequentist = FALSE,
  offset = NULL,
  ncores = 1,
  partial_match = FALSE,
  ...,
  newdata = NULL
)
}
\arguments{
\item{object}{an R object to compute derivatives for.}

\item{...}{arguments passed to other methods.}

\item{select}{character; select which smooth's posterior to draw from.
The default (\code{NULL}) means the posteriors of all smooths in \code{model}
will be sampled from. If supplied, a character vector of requested terms.
Can be a partial match to a smooth term; see argument \code{partial_match}
below.}

\item{term}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{select} instead.}

\item{data}{a data frame containing the values of the model covariates
at which to evaluate the first derivatives of the smooths.}

\item{order}{numeric; the order of derivative.}

\item{type}{character; the type of finite difference used. One of
\code{"forward"}, \code{"backward"}, or \code{"central"}.}

\item{n}{numeric; the number of points to evaluate the derivative at.}

\item{eps}{numeric; the finite difference.}

\item{interval}{character; the type of interval to compute. One of
\code{"confidence"} for point-wise intervals, or \code{"simultaneous"} for
simultaneous intervals.}

\item{n_sim}{integer; the number of simulations used in computing the
simultaneous intervals.}

\item{level}{numeric; \verb{0 < level < 1}; the confidence level of the
point-wise or simultaneous interval. The default is \code{0.95} for a 95\%
interval.}

\item{unconditional}{logical; use smoothness selection-corrected Bayesian
covariance matrix?}

\item{frequentist}{logical; use the frequentist covariance matrix?}

\item{offset}{numeric; a value to use for any offset term}

\item{ncores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{term}? If \code{TRUE}, \code{term} can only be a single string to match
against.}

\item{newdata}{Deprecated: use \code{data} instead.}
}
\value{
A tibble, currently with the following variables:
\itemize{
\item \code{.smooth}: the smooth each row refers to,
\item \code{.by}: the name of any factor by variable involved in the smooth,
\item \code{.fs}: the name of any random factor variable involved in the smooth,
\item \code{.derivative}: the estimated derivative,
\item \code{.se}: the standard error of the estimated derivative,
\item \code{.crit}: the critical value such that \code{derivative} ± \code{(crit * se)} gives
the upper and lower bounds of the requested confidence or simultaneous
interval (given \code{level}),
\item \code{.lower_ci}: the lower bound of the confidence or simultaneous interval,
\item \code{.upper_ci}: the upper bound of the confidence or simultaneous interval.
\item plus one or more columns of data containing the values of covariates at
which the derivative was evaluated.
}
}
\description{
Derivatives of estimated smooths via finite differences
}
\note{
\code{derivatives()} will ignore any random effect smooths it encounters in
\code{object}.
}
\examples{

load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
dat <- data_sim("eg1", n = 400, dist = "normal", scale = 2, seed = 42)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivatives of all smooths using central finite differences
derivatives(mod, type = "central")

## derivatives for a selected smooth
derivatives(mod, type = "central", select = "s(x1)")
## or via a partial match
derivatives(mod, type = "central", select = "x1", partial_match = TRUE)
\dontshow{
options(op)
}
}
\author{
Gavin L. Simpson
}
