% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.mar}
\alias{simulate.mar}
\title{Generate synthetic data from a Mixture Autoregressive model}
\usage{
\method{simulate}{mar}(object, nsim = 100, seed = NULL, n.start = 100, ...)
}
\arguments{
\item{object}{A `mar` object, usually the output of \code{\link{mar_model}()}.}

\item{nsim}{length of series to generate}

\item{seed}{Either \code{NULL} or an integer that will be used in a call to
\code{\link[base]{set.seed}} before simulating the time series. The default,
\code{NULL}, will not change the random generator state.}

\item{n.start}{Length of 'burn-in' period.}

\item{...}{Other arguments, not currently used.}
}
\value{
`ts` object of length \code{nsim}.
}
\description{
This function simulates one random sample path from a mixture of k Gaussian AR(p) processes.
The model is of the form
\deqn{y_t = \phi_{0,i} + \phi_{1,i}y_{t-1} + \dots + \phi_{p,i}y_{t-p} + \sigma_{i,t}\epsilon_t}
with probability \eqn{\alpha_i}, where \eqn{\epsilon_t} is a N(0,1) variate.
}
\examples{
# MAR model with constant variances
phi <- cbind(c(0, 0.8, 0), c(0, 0.6, 0.3))
weights <- c(0.8, 0.2)
model1 <- mar_model(phi = phi, sigmas = c(1, 2), weights = weights)
y <- simulate(model1, 100)
plot(y)

# MAR model with heteroskedastic errors
sigmas.spec <- list(
  fGarch::garchSpec(model = list(alpha = c(0.05, 0.06))),
  fGarch::garchSpec(model = list(alpha = c(0.05, 0.05)))
)
model2 <- mar_model(phi = phi, sigmas = sigmas.spec, weights = weights)
y <- simulate(model2, 100)
plot(y)
}
\references{
Feng Li, Mattias Villani, and Robert Kohn. (2010). Flexible Modeling of
    Conditional Distributions using Smooth Mixtures of Asymmetric Student T Densities,
    Journal of Statistical Planning and Inference, 140(12), pp. 3638-3654.
}
\seealso{
\code{\link{mar_model}}
}
\author{
Rob J Hyndman
}
