% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicStuff.R
\name{multipliers}
\alias{multipliers}
\title{Dynamic multipliers from an ARDL model}
\usage{
multipliers(object, parm, h = 10)
}
\arguments{
\item{object}{An estimated ALM model object (with coefficients from \code{coef()}).}

\item{parm}{Character string of the variable name.}

\item{h}{Horizon for which to produce the dynamic multipliers.}
}
\value{
Numeric vector of dynamic multipliers over time
}
\description{
This function extracts the beta (distributed lag) coefficients for a specific
variable from an estimated ALM model and ARIMA(p,d,0) polynomials. It then uses
them to calculate dynamic multipliers for that variable for the horizon \code{h}.
}
\examples{
\dontrun{
  # Fit a model with lagged variables
  test <- alm(drivers ~ kms + law + B(kms, 1) + B(kms, 2),
              Seatbelts, orders = c(1, 0, 0))
  multipliers(test, "kms", h=10)
}

}
\seealso{
,
\code{\link[greybox]{B}} for creating lagged variables
}
