% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing.R
\name{plot_qa}
\alias{plot_qa}
\title{plotting quality assessment per radius}
\usage{
plot_qa(qa.trt, qa.out_series = "all")
}
\arguments{
\item{qa.trt}{object "cfs_qa" from CFS_qa() function.}

\item{qa.out_series}{series_id list to be plotted, default "all" for plotting the graphs for all.}
}
\value{
A named list of tree-ring series, where each element corresponds to
a series requested via \code{qa.out_series}. Each element is itself a list
containing four \code{ggplot} objects:
\describe{
  \item{plot.raw.series}{Raw tree-ring series vs year.}
  \item{plot.trt.series}{Treated (detrended/standardized) series vs year.}
  \item{plot.raw.ccf}{Cross-correlation function of the raw series.}
  \item{plot.trt.ccf}{Cross-correlation function of the treated series.}
}
}
\description{
Plotting the time series and cross-correlation to contrast each radius with the chronologies, using both raw ring-width measurements and treated series.
}
\examples{
\donttest{

# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# data processing
dt.samples_long <- prepare_samples_clim(
dt.samples_trt = dt.samples_trt, calbai = FALSE )
# rename to the reserved column name
data.table::setnames(
dt.samples_long,
c("sample_id", "year", "rw_mm"),
c("SampleID", "Year" ,"RawRing"))
# assign treated series
# users can decide their own treated series

# for rhub::rhub_check() on macos VECTOR_ELT issues
data.table::setorder(dt.samples_long, SampleID, Year)
dt.samples_long$RW_trt <-
  ave(
  as.numeric(dt.samples_long$RawRing),
  dt.samples_long$SampleID,
  FUN = function(x)
  if (length(x) > 1L) c(NA_real_, diff(x)) else NA_real_
  )
# quality check on radius alignment based on the treated series
dt.qa <-CFS_qa(dt.input = dt.samples_long, qa.label_data = "demo-samples",
qa.label_trt = "difference", qa.min_nseries = 5)
plots.lst <- plot_qa(dt.qa, qa.out_series = "X003_101_005")
}

}
