% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carma.r
\name{carma}
\alias{carma}
\alias{fitted.carma}
\alias{mprofile.carma}
\alias{residuals.carma}
\alias{coef.carma}
\alias{deviance.carma}
\alias{print.carma}
\title{Continuous ARMA for Unequally Spaced Repeated Measurements}
\usage{
carma(
  response = NULL,
  ccov = NULL,
  times = NULL,
  torder = 0,
  interaction,
  arma = c(0, 0, 0),
  parma = NULL,
  pre = NULL,
  position = NULL,
  iopt = TRUE,
  resid = TRUE,
  transform = "identity",
  delta = NULL,
  envir = parent.frame(),
  print.level = 0,
  typsize = abs(p),
  ndigit = 10,
  gradtol = 1e-05,
  steptol = 1e-05,
  iterlim = 100,
  fscale = 1,
  stepmax = 10 * sqrt(p \%*\% p)
)

\method{coef}{carma}(object, ...)

\method{deviance}{carma}(object, ...)

\method{residuals}{carma}(object, recursive = TRUE, ...)

\method{print}{carma}(x, digits = max(3, .Options$digits - 3), correlation = TRUE, ...)

\method{mprofile}{carma}(z, times = NULL, ccov, plotse = TRUE, ...)
}
\arguments{
\item{response}{A list of two column matrices with response values and times
for each individual, one matrix or dataframe of response values, or an
object of either class, \code{response} (created by
\code{\link[rmutil]{restovec}}) or \code{repeated} (created by
\code{\link[rmutil]{rmna}} or \code{\link[rmutil]{lvna}}). If the
\code{repeated} data object contains more than one response variable, give
that object in \code{envir} and give the name of the response variable to be
used here.}

\item{ccov}{A matrix of columns of baseline covariates with one row per
individual, a model formula using vectors of the same size, or an object of
class, \code{tccov} (created by \code{\link[rmutil]{tcctomat}}). If response
has class, \code{repeated}, the covariates must be specified as a Wilkinson
and Rogers formula unless none are to be used.}

\item{times}{When response is a matrix, a vector of possibly unequally
spaced times when they are the same for all individuals or a matrix of
times. Not necessary if equally spaced. Ignored if response has class,
\code{response} or \code{repeated}.}

\item{torder}{Order of the polynomial in time to be fitted.}

\item{interaction}{Vector indicating order of interactions of covariates
with time.}

\item{arma}{Vector of three values: order of AR, order of MA, binary
indicator for presence of measurement error. Not required for an AR(1) if an
initial estimate is supplied. If only one value is supplied, it is assumed
to be the order of the AR.}

\item{parma}{Initial estimates of ARMA parameters. For example, with
\code{arma=c(1,0,0)}, an AR(1), the parameter is \code{parma[1]=log(theta)},
where \code{theta} is the positive, continuous time autoregressive
coefficient. The finite step autoregression coefficient for a step of length
\code{delta} is then \code{alpha=exp(-delta*theta)} i.e.
\code{alpha=exp(-delta*exp(parma[1]))}.}

\item{pre}{Initial estimates of random effect parameters.}

\item{position}{Two column matrix with rows giving index positions of random
effects in the covariance matrix.}

\item{iopt}{TRUE if optimization should be performed.}

\item{resid}{TRUE if residuals to be calculated.}

\item{transform}{Transformation of the response variable: \code{identity},
\code{exp}, \code{square}, \code{sqrt}, or \code{log}.}

\item{delta}{Scalar or vector giving the unit of measurement for each
response value, set to unity by default. For example, if a response is
measured to two decimals, \code{delta=0.01}. Ignored if response has class,
\code{response} or \code{repeated}.}

\item{envir}{Environment in which model formulae are to be interpreted or a
data object of class, \code{repeated}, \code{tccov}, or \code{tvcov}; the
name of the response variable should be given in \code{response}. If
\code{response} has class \code{repeated}, it is used as the environment.}

\item{print.level}{Arguments for nlm.}

\item{typsize}{Arguments for nlm.}

\item{ndigit}{Arguments for nlm.}

\item{gradtol}{Arguments for nlm.}

\item{steptol}{Arguments for nlm.}

\item{iterlim}{Arguments for nlm.}

\item{fscale}{Arguments for nlm.}

\item{stepmax}{Arguments for nlm.}

\item{object}{An object of class, \code{carma}.}

\item{...}{additional arguments.}

\item{recursive}{If TRUE, recursive residuals or fitted values are given;
otherwise, marginal ones.}

\item{x}{An object of class, \code{carma}.}

\item{digits}{number of digits to print.}

\item{correlation}{logical; print correlations.}

\item{z}{An object of class, \code{carma}.}

\item{plotse}{Plot the standard errors around the marginal profile curve.}
}
\value{
A list of class \code{carma} is returned that contains all of the
relevant information calculated, including error codes.
}
\description{
\code{carma} is designed to handle a polynomial within subject design matrix
with unequally spaced observations which can be at different times for
different subjects. The origin of time is taken as the mean time of all the
subjects. The within subject errors are assumed to be independent Gaussian
or have a continuous time ARMA(p,q) Gaussian structure with the option to
include measurement error. The between subject random coefficients are
assumed to have an arbitrary covariance matrix. The fixed effect design
matrix is a polynomial of equal or higher order than the within subject
design matrix. This matrix can be augmented by covariates multiplied by
polynomial design matrices of any order up to the order of the first
partition of the design matrix. The method is based on exact maximum
likelihood using the Kalman filter to calculate the likelihood.
}
\details{
For clustered (non-longitudinal) data, where only random effects will be
fitted, \code{times} are not necessary.

Marginal and individual profiles can be plotted using
\code{\link[rmutil]{mprofile}} and \code{\link[rmutil]{iprofile}} and
residuals with \code{\link[rmutil]{plot.residuals}}.

For any ARMA of order superior to an AR(1), the (complex) roots of the
characteristic equation are printed out; see Jones and Ackerson (1991) for
their use in calculation of the covariance function.
}
\section{Methods (by generic)}{
\itemize{
\item \code{coef(carma)}: Coefficients

\item \code{deviance(carma)}: Deviance

\item \code{residuals(carma)}: Residuals

\item \code{print(carma)}: Print method

\item \code{mprofile(carma)}: Special marginal profiles with SEs

}}
\examples{

y <- matrix(rnorm(40),ncol=5)
x1 <- gl(2,4)
x2 <- gl(2,1,8)
# independence with time trend
carma(y, ccov=~x1, torder=2)
# AR(1)
carma(y, ccov=~x1, torder=2, arma=c(1,0,0), parma=-0.5)
carma(y, ccov=~x1, torder=3, interact=3, arma=c(1,0,0), parma=-1)
# ARMA(2,1)
carma(y, ccov=~x1+x2, interact=c(2,0), torder=3,arma=c(2,1,0),
	parma=c(0.3,2,0.7))
# random intercept
carma(y, ccov=~x1+x2, interact=c(2,0), torder=3, pre=-0.4, 
	position=c(1,1))
# random coefficients
carma(y, ccov=~x1+x2, interact=c(2,0), torder=3, pre=c(-0.4,0.1), 
	position=rbind(c(1,1),c(2,2)))

}
\references{
Jones, R. H. and Ackerson, L. M. (1991) Serial correlation in
unequally spaced longitudinal data. Biometrika, 77, 721-731.

Jones, R.H. (1993) Longitudinal Data Analysis with Serial Correlation: A
State-space Approach. Chapman and Hall
}
\seealso{
\code{\link[growth]{elliptic}}, \code{\link[repeated]{gar}},
\code{\link[repeated]{gnlmix}}, \code{\link[repeated]{glmm}},
\code{\link[repeated]{gnlmm}}, \code{\link[rmutil]{iprofile}},
\code{\link[repeated]{kalseries}}, \code{\link[rmutil]{mprofile}},
\code{\link[rmutil]{plot.residuals}}, \code{\link[growth]{potthoff}},
\code{\link[rmutil]{read.list}}, \code{\link[rmutil]{restovec}},
\code{\link[rmutil]{rmna}}, \code{\link[rmutil]{tcctomat}},
\code{\link[rmutil]{tvctomat}}.
}
\author{
R.H. Jones and J.K. Lindsey
}
\keyword{models}
