\name{plotBoundary}
\alias{plotBoundary}
\title{A boundary plot for a  gsearly model}
\usage{plotBoundary(mod, xlim=c(0,1), ylim=NA, xlab=NA, ylab=NA, title=NULL, col=1,
    lty=c(3, 3), pch=3, las=1, concol=grey(0.9), reglab=TRUE,  signif=3,
    bounds=TRUE, pcol=1, labpos=c(2,2), ...)}
\description{A boundary plot for a gsearly model.}
\arguments{
 \item{mod}{A gsearly model from function \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}} functions.}
 \item{xlim}{The \code{x} limits \code{c(x1, x2)} of the plot; default
   \code{NA}.}
 \item{ylim}{The \code{y} limits of the plot; default \code{NA}.}
 \item{xlab}{A label for the x axis; defaults to \code{"Information"}.}
 \item{ylab}{A label for the y axis; defaults to
   \code{"Normal Critical Values"}.}
 \item{title}{A main title for the plot; default \code{NULL}.}
 \item{col}{Default plotting color for lines and points; default 1.}
 \item{lty}{A vector of line types for upper and lower boundaries;  default
   \code{c(2, 2)}.}
 \item{pch}{Plotting character or symbol for points; default 3.}
 \item{las}{A numeric value which is one of either 0, 1, 2 or 3; the style of
   axis labels, 0: always parallel to the axis, 1: always horizontal (default),
   2: always perpendicular to the axis, 3: always vertical.}
 \item{concol}{Color for the continue region, default \code{grey(0.9)}. Set to
   \code{grey(1)} for no color.}
 \item{reglab}{Logical for plotting of region (Continue, Reject H0 and
   Accept H0) labels; default \code{TRUE}.}
 \item{signif}{Number of decimal places for the boundaries; default 3.}
 \item{bounds}{Logical for plotting boundary values; default \code{TRUE}.}
 \item{pcol}{Color for region labels and points; default 1.}
 \item{labpos}{Position for upper and lower boundary values (if
   \code{bounds=TRUE}); default \code{c(2, 2)}.}
 \item{...}{Further arguments to plot function.}
}
\value{
 A plot of the selected type or a list consisting of interim information
 fractions and lower and upper boundaries.
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="fix", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8,
                   cmodel="exponential", sd=20, rho=0.75, theta=8, fp=fp, tn=tn)
 plotBoundary(rctdesign)

}
