% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_likert.R
\name{tbl_likert}
\alias{tbl_likert}
\title{Likert Summary}
\usage{
tbl_likert(
  data,
  statistic = ~"{n} ({p}\%)",
  label = NULL,
  digits = NULL,
  include = everything(),
  sort = c("ascending", "descending")
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to specify the summary statistics for each variable.
The default is \code{everything() ~ "{n} ({p}\%)"}.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{digits}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s)
or function(s). If not specified, default formatting is assigned
via \code{assign_summary_digits()}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}

\item{sort}{(\code{string})\cr
indicates whether levels of variables should be placed in
ascending order (the default) or descending.}
}
\value{
a 'tbl_likert' gtsummary table
}
\description{
Create a table of ordered categorical variables in a wide format.
}
\examples{
levels <- c("Strongly Disagree", "Disagree", "Agree", "Strongly Agree")
df_likert <- data.frame(
  recommend_friend = sample(levels, size = 20, replace = TRUE) |> factor(levels = levels),
  regret_purchase = sample(levels, size = 20, replace = TRUE) |> factor(levels = levels)
)

# Example 1 ----------------------------------
tbl_likert_ex1 <-
  df_likert |>
  tbl_likert(include = c(recommend_friend, regret_purchase)) |>
  add_n()
tbl_likert_ex1

# Example 2 ----------------------------------
# Add continuous summary of the likert scores
list(
  tbl_likert_ex1,
  tbl_wide_summary(
    df_likert |> dplyr::mutate(dplyr::across(everything(), as.numeric)),
    statistic = c("{mean}", "{sd}"),
    type = ~"continuous",
    include = c(recommend_friend, regret_purchase)
  )
) |>
  tbl_merge(tab_spanner = FALSE)
}
