% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_usr.R
\name{text_usr}
\alias{text_usr}
\title{Add Text to a Plot at Normalized Device Coordinates}
\source{
From \url{https://stackoverflow.com/questions/25450719/plotting-text-in-r-at-absolute-position}
}
\usage{
text_usr(x, y, labels, ...)
}
\arguments{
\item{x, y}{numeric vectors of coordinates in (0, 1) where the text \code{labels} should be written. If the length of
\code{x} and \code{y} differs, the shorter one is recycled. Alternatively, a single argument \code{x} can be provided.}

\item{labels}{a character vector or \code{\link[base]{expression}} specifying the text to be written}

\item{...}{other arguments passed to \code{\link[graphics]{text}}, such as \code{pos}, \code{cex}, \code{col}, ...}
}
\description{
\code{text_usr()} draws the strings given in the vector labels at the coordinates given by \code{x} and \code{y},
but using normalized device coordinates (0, 1) to position text at absolute locations in a plot.
This is useful when you know where in a plot you want to add some text annotation, but don't want to figure
out what the data coordinates are.
}
\details{
\code{y} may be missing since \code{\link[grDevices]{xy.coords}} is used for construction of the coordinates.

The function also works with \code{par(xlog) == TRUE} and \code{par(ylog) == TRUE} when either of these is set
for log scales.
}
\examples{
library(heplots)
x = c(0.5, rep(c(0.05, 0.95), 2))
y = c(0.5, rep(c(0.05, 0.95), each=2))
plot(x, y, pch = 16,
     xlim = c(0,1),
     ylim = c(0,1))
text_usr(0.05, 0.95, "topleft",    pos = 4)
text_usr(0.95, 0.95, "topright",   pos = 2)
text_usr(0.05, 0.05, "bottomleft", pos = 4)
text_usr(0.95, 0.05, "bottomright",pos = 2)

}
\keyword{utilities}
