% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_frt.R
\name{get_testing_grid}
\alias{get_testing_grid}
\title{Build a grid of treatment effect models for interaction testing}
\usage{
get_testing_grid(Y, Z, W, X = NULL, gamma = 1e-04, grid.size = 150)
}
\arguments{
\item{Y}{Outcome vector.}

\item{Z}{Treatment assignment vector (0/1).}

\item{W}{Covariate matrix for treatment effect interactions.}

\item{X}{Optional covariate matrix for additional adjustment.}

\item{gamma}{Tail probability for the confidence region. Default is 0.0001.}

\item{grid.size}{Number of models to sample. Default is 150.}
}
\value{
A list with components:
  \describe{
    \item{te.grid}{grid.size x p matrix, each row a different effect model.}
    \item{te.mat}{N x grid.size matrix of individual treatment effects.}
    \item{Y0.mat}{N x grid.size matrix of imputed control potential outcomes.}
    \item{Y1.mat}{N x grid.size matrix of imputed treated potential outcomes.}
  }
}
\description{
Estimates a linear model \code{Y ~ Z + W + Z:W (+X)} and samples from
the confidence region of the Z-related coefficients. For each sampled
model, computes individual imputed treatment effects and science tables
of imputed potential outcomes.
}
\keyword{internal}
