% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_output_type.R
\name{convert_output_type}
\alias{convert_output_type}
\title{Transform between output types}
\usage{
convert_output_type(model_out_tbl, to)
}
\arguments{
\item{model_out_tbl}{an object of class \code{model_out_tbl} containing predictions
with a single, unique value in the \code{output_type} column.}

\item{to}{a named list indicating the desired output types and associated
output type IDs. List item name and value pairs may be as follows:
\itemize{
\item \code{mean}: \code{NA} (no associated output type ID)
\item \code{median}: \code{NA} (no associated output type ID)
\item \code{quantile}: a numeric vector of probability levels OR a dataframe of
probability levels and the task ID variables they depend upon.
(See examples section for an example of each.)
Note that any task ID variable value must appear in the associated
\code{model_out_tbl} task ID column
}}
}
\value{
object of class \code{model_out_tbl} containing (only) predictions of the
to output_type(s) for each unique combination of task IDs for each model
}
\description{
Transform between output types for each unique combination of task IDs for each
model. Conversion must be from a single initial output type to one or more
to output types, and the resulting output will only contain the to
output types. See details for supported conversions.
}
\details{
Currently, only \code{"sample"} can be converted to \code{"mean"}, \code{"median"},
or \code{"quantile"}
}
\examples{
# We illustrate the conversion between output types using normal distributions
ex_quantiles <- c(0.25, 0.5, 0.75)
model_out_tbl <- expand.grid(
  stringsAsFactors = FALSE,
  group1 = c(1, 2),
  model_id = "A",
  output_type = "sample",
  output_type_id = 1:100
) |>
  dplyr::mutate(value = rnorm(200, mean = group1))

# Output type conversions with vector `to` elements
convert_output_type(model_out_tbl,
  to = list("quantile" = ex_quantiles, "median" = NA)
)

# Output type conversion with dataframe `to` element
# Output type ID values (quantile levels) are determined by group1 value
quantile_levels <- rbind(
  data.frame(group1 = 1, output_type_id = 0.5),
  data.frame(group1 = 2, output_type_id = c(0.25, 0.5, 0.75))
)
convert_output_type(model_out_tbl,
  to = list("quantile" = quantile_levels)
)

}
