% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_Function.R
\name{iSTAY_Hier}
\alias{iSTAY_Hier}
\title{Calculate stability and synchrony at each hierarchical level}
\usage{
iSTAY_Hier(
  data,
  structure,
  order.q = c(1, 2),
  Alltime = TRUE,
  start_T = NULL,
  end_T = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} containing the hierarchical data, with sampling units as rows and time points as columns.}

\item{structure}{The hierarchical structure of the input data.}

\item{order.q}{A numerical vector specifying the orders of stability. Default is c(1,2).}

\item{Alltime}{Logical (\code{TRUE} or \code{FALSE}), indicating whether to use all time points in the data.}

\item{start_T}{(Applicable only if \code{Alltime = FALSE}) a positive integer specifying the starting column (time point) for the analysis interval.}

\item{end_T}{(Applicable only if \code{Alltime = FALSE}) a positive integer specifying the ending column (time point) for the analysis interval.}
}
\value{
a data frame with the following columns: \cr
 Hier_level: hierarchical level (e.g. Level 1: population, Level 2: community, Level 3: block, and level 4: overall data) \cr
 Order_q: order of stability or synchrony \cr
 Gamma, Alpha, Beta: stability measures of order q \cr
 Synchrony: synchrony measure of order q
}
\description{
\code{iSTAY_Hier} computes gamma, alpha, and beta stability, as well as synchrony, at each hierarchical level for time series of biomass or other variables.
}
\examples{

data("Data_Jena_462_populations")
data("Data_Jena_hierarchical_structure")
output_hier <- iSTAY_Hier(data = Data_Jena_462_populations, 
         structure = Data_Jena_hierarchical_structure,
         order.q=c(1,2), Alltime=TRUE)
output_hier


}
