% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.iv.sensemakr}
\alias{plot.iv.sensemakr}
\title{Sensitivity analysis plots for IV sensemakr}
\usage{
\method{plot}{iv.sensemakr}(x, sensitivity.of = c("ci", "lwr", "upr", "t-value"), parm = "iv", ...)
}
\arguments{
\item{x}{an object of class \code{iv.sensemakr} created with the \code{\link{sensemakr}} function.}

\item{sensitivity.of}{should the contour plot show adjusted lower limits of confidence intervals (\code{"lwr"}), upper limit of confidence intervals (\code{"upr"}) or t-values (\code{"t-value"})?}

\item{parm}{contour plots of which estimate? Options are \code{iv} for instrumental variable estimates, \code{fs} for first-stage estimates, and \code{rf} for reduced-form estimates.}

\item{...}{further arguments and graphical parameters.}
}
\value{
The function is called for its side effect of producing contour plots.
It invisibly returns the output from \code{\link{ovb_contour_plot}}.
}
\description{
This function provides the contour plots of the sensitivity analysis results obtained with the function \code{\link{sensemakr}} for IV. It is basically a dispatcher to the core plot function \code{\link{ovb_contour_plot}}.
}
\examples{
data("card")
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)
card.fit <- iv_fit(y, d, z, x)
card.sens <- sensemakr(card.fit, benchmark_covariates = "black")
plot(card.sens, lim = 0.09)
}
