% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_pca.R
\name{Procrustes}
\alias{Procrustes}
\title{Procrustes Analysis}
\usage{
Procrustes(X1, X2, plot = NULL, labels = NULL)
}
\arguments{
\item{X1}{A matrix or data.frame containing a PCA/PCoA/MDS projection.}

\item{X2}{A second matrix or data.frame containing a different PCA/PCoA/MDS projection,
with the same number of rows than X1.}

\item{plot}{(optional) A `ggplot2` is displayed. The input should be a vector of
integers with length 2, corresponding to the two Principal Components to be displayed in the plot.}

\item{labels}{(optional) A vector of the same length than nrow(X1), or instead,
nrow(X1)+nrow(X2). A name will be displayed next to each point.}
}
\value{
A list containing:

* X1 (zero-centered and scaled).

* X2 superimposed over X1 (after translating, scaling and rotating X2).

* Procrustes correlation between X1 and X2.

* (optional) A `ggplot2` plot.
}
\description{
Procrustes Analysis compares two PCA/PCoA/MDS/other ordination methods'
projections after "removing" the translation, scaling and rotation effects.
Thus, they are compared in their configuration of "maximum similarity".
Samples in the two projections should be related. The similarity of the projections
X1 and X2 is quantified using a correlation-like statistic derived from the
symmetric Procrustes sum of squared differences between X1 and X2.
}
\details{
`Procrustes()` performs a Procrustes Analysis equivalent to
`vegan::procrustes(X,Y,scale=FALSE,symmetric=TRUE)`.
}
\examples{
data1 <- matrix(rnorm(900),ncol=30,nrow=30)
data2 <- matrix(rnorm(900),ncol=30,nrow=30)
pca1 <- kPCA(Linear(data1),center=TRUE)
pca2 <- kPCA(Linear(data2),center=TRUE)
procr <- Procrustes(pca1,pca2)
# Procrustean correlation between pca1 and pca2:
procr$pro.cor
# With plot (first two axes):
procr <- Procrustes(pca1,pca2,plot=1:2,labels=1:30)
procr$plot
}
