% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{compare_keys}
\alias{compare_keys}
\title{Compare key values between two data frames}
\usage{
compare_keys(x, y, by = NULL)
}
\arguments{
\item{x}{First keyed data frame.}

\item{y}{Second keyed data frame.}

\item{by}{Column(s) to compare. If NULL, uses the key from x.}
}
\value{
A key comparison object.
}
\description{
Identifies keys that are new, removed, or common between two keyed
data frames. Does not compare values, only key membership.
}
\examples{
df1 <- key(data.frame(id = 1:3, x = 1:3), id)
df2 <- key(data.frame(id = 2:4, x = 2:4), id)
compare_keys(df1, df2)

}
