% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff.keyed_df}
\alias{diff.keyed_df}
\title{Diff two keyed data frames}
\usage{
\method{diff}{keyed_df}(x, y, ...)
}
\arguments{
\item{x}{A keyed data frame (the "old" or "reference" state).}

\item{y}{A data frame (the "new" state). Must contain the key columns from \code{x}.}

\item{...}{Ignored (present for S3 compatibility with \code{\link[base:diff]{base::diff()}}).}
}
\value{
A \code{keyed_diff} object with fields:
\itemize{
\item \code{key_cols}: character vector of key column names
\item \code{n_removed}, \code{n_added}, \code{n_modified}, \code{n_unchanged}: counts
\item \code{removed}: data frame of rows in \code{x} not in \code{y}
\item \code{added}: data frame of rows in \code{y} not in \code{x}
\item \code{changes}: named list of per-column change tibbles
(each with key columns, \code{old}, and \code{new})
\item \code{cols_only_x}, \code{cols_only_y}: columns present in only one side
}
}
\description{
Compares two data frames row-by-row using the key from \code{x} to align rows.
Identifies added, removed, and modified rows, with cell-level detail for
modifications.
}
\examples{
old <- key(data.frame(id = 1:3, x = c("a", "b", "c")), id)
new <- data.frame(id = 2:4, x = c("B", "c", "d"))
diff(old, new)

}
