% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{stamp}
\alias{stamp}
\alias{commit_keyed}
\title{Stamp a data frame as reference}
\usage{
stamp(.data, name = NULL, .silent = FALSE)

commit_keyed(.data, name = NULL)
}
\arguments{
\item{.data}{A data frame (preferably keyed).}

\item{name}{Optional name for the snapshot. If NULL, derived from data.}

\item{.silent}{If \code{TRUE}, suppress cli output. Used internally by
auto-stamping in \code{\link[=watch]{watch()}}ed data frames.}
}
\value{
Invisibly returns \code{.data} with snapshot metadata attached.
}
\description{
Stores a snapshot of the current data state, including the full data frame.
This enables cell-level drift reports when used with \code{\link[=check_drift]{check_drift()}}.
}
\details{
Snapshots are stored in memory for the session. They are keyed by
content hash, so identical data shares the same snapshot.

When data is \code{\link[=watch]{watch()}}ed, dplyr verbs auto-stamp before executing,
creating an automatic safety net for drift detection.
}
\examples{
df <- key(data.frame(id = 1:3, x = c("a", "b", "c")), id)
df <- stamp(df)

# Later, check for drift
df2 <- df
df2$x[1] <- "z"
check_drift(df2)

}
\seealso{
\code{\link[=watch]{watch()}} for automatic stamping before dplyr verbs.
}
