% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{watch}
\alias{watch}
\title{Watch a keyed data frame for automatic drift detection}
\usage{
watch(.data)
}
\arguments{
\item{.data}{A keyed data frame.}
}
\value{
Invisibly returns \code{.data} with watched attribute set and
a baseline snapshot committed.
}
\description{
Marks a keyed data frame as "watched". Watched data frames are
automatically stamped before each dplyr verb, so \code{\link[=check_drift]{check_drift()}} always
reports changes from the most recent transformation step.
}
\examples{
df <- key(data.frame(id = 1:5, x = letters[1:5]), id) |> watch()
df2 <- df |> dplyr::filter(id > 2)
check_drift(df2)

}
\seealso{
\code{\link[=unwatch]{unwatch()}} to stop watching, \code{\link[=stamp]{stamp()}} for manual snapshots.
}
