% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{ids}
\alias{ids}
\title{Get the trajectory ids on which the model was fitted}
\usage{
ids(object)
}
\arguments{
\item{object}{The \code{lcModel} object.}
}
\value{
A \verb{character vector} or \verb{integer vector} of the identifier for every fitted trajectory.
}
\description{
Get the trajectory ids on which the model was fitted
}
\details{
The order returned by \code{ids(object)} determines the id order for any output involving id-specific values, such as in \code{\link[=trajectoryAssignments]{trajectoryAssignments()}} or \code{\link[=postprob]{postprob()}}.
}
\examples{
data(latrendData)
method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
ids(model) # 1, 2, ..., 200
}
\seealso{
Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
