% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{add_lM}
\alias{add_lM}
\title{Add Matrices to a lefkoMat or lefkoMatList Object}
\usage{
add_lM(
  lM,
  Amats = NA,
  Umats = NA,
  Fmats = NA,
  UFdecomp = FALSE,
  entrystage = 1,
  pop = NA,
  patch = NA,
  year = NA
)
}
\arguments{
\item{lM}{The \code{lefkoMat} or \code{lefkoMatList} object to add matrices
to.}

\item{Amats}{Either a single \code{A} matrix, or a list of \code{A} matrices.
Not necessary if \code{Umats} and \code{Fmats} are both provided.}

\item{Umats}{Either a single \code{U} matrix, or a list of \code{U} matrices.
Not necessary if \code{Amats} and \code{Fmats} are both provided, or if
\code{UFdecomp = TRUE} and \code{entrystage} is provided.}

\item{Fmats}{Either a single \code{F} matrix, or a list of \code{U} matrices.
Not necessary if \code{Amats} and \code{Umats} are both provided, or if
\code{UFdecomp = TRUE} and \code{entrystage} is provided.}

\item{UFdecomp}{A logical value indicating whether U and F matrices should be
inferred from A matrices and the given \code{entrystage}. Defaults to TRUE.}

\item{entrystage}{The stage or stages produced by reproductive individuals.
Used to determine which transitions are reproductive for U-F decomposition.
Defaults to \code{1}, which corresponds to the first stage in the stageframe.}

\item{pop}{The population designation for each matrix. If object \code{lM}
includes only a single population, then defaults to that designation.
Otherwise requires a designation as input.}

\item{patch}{The patch designation for each matrix. If object \code{lM}
includes only a single patch, then defaults to that designation. Otherwise
requires a designation as input.}

\item{year}{The designation for occasion at time \emph{t} corresponding to
each matrix. Cannot be left empty.}
}
\value{
A \code{lefkoMat} or \code{lefkoMatList} object incorporating the new
matrices within the object input in \code{lM}. Note that if a
\code{lefkoMatList} object is used as input, then ALL composite
\code{lefkoMat} objects will have the same matrices added in exactly the same
way.
}
\description{
Function \code{add_lM()} adds matrices to \code{lefkoMat} and
\code{lefkoMatList} objects.
}
\section{Notes}{

This function will not allow matrices of different dimension from those input
in object \code{lM} to be added to that object.

Two of \code{Amats}, \code{Umats}, and \code{Fmats} must be provided for this
function to proceed. Also, if \code{Amats}, \code{Umats}, and \code{Fmats}
are all provided, then this function will default to replacing \code{Amats}
with the sum of the respective \code{Umats} and \code{Fmats}.
}

\examples{
# These matrices are of 9 populations of the plant species Anthyllis
# vulneraria, and were originally published in Davison et al. (2010) Journal
# of Ecology 98:255-267 (doi: 10.1111/j.1365-2745.2009.01611.x).

sizevector <- c(1, 1, 2, 3) # These sizes are not from the original paper
stagevector <- c("Sdl", "Veg", "SmFlo", "LFlo")
repvector <- c(0, 0, 1, 1)
obsvector <- c(1, 1, 1, 1)
matvector <- c(0, 1, 1, 1)
immvector <- c(1, 0, 0, 0)
propvector <- c(0, 0, 0, 0)
indataset <- c(1, 1, 1, 1)
binvec <- c(0.5, 0.5, 0.5, 0.5)

anthframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

# POPN C 2003-2004
XC3 <- matrix(c(0, 0, 1.74, 1.74,
0.208333333, 0, 0, 0.057142857,
0.041666667, 0.076923077, 0, 0,
0.083333333, 0.076923077, 0.066666667, 0.028571429), 4, 4, byrow = TRUE)

# 2004-2005
XC4 <- matrix(c(0, 0, 0.3, 0.6,
0.32183908, 0.142857143, 0, 0,
0.16091954, 0.285714286, 0, 0,
0.252873563, 0.285714286, 0.5, 0.6), 4, 4, byrow = TRUE)

# 2005-2006
XC5 <- matrix(c(0, 0, 0.50625, 0.675,
0, 0, 0, 0.035714286,
0.1, 0.068965517, 0.0625, 0.107142857,
0.3, 0.137931034, 0, 0.071428571), 4, 4, byrow = TRUE)

# POPN E 2003-2004
XE3 <- matrix(c(0, 0, 2.44, 6.569230769,
0.196428571, 0, 0, 0,
0.125, 0.5, 0, 0,
0.160714286, 0.5, 0.133333333, 0.076923077), 4, 4, byrow = TRUE)

XE4 <- matrix(c(0, 0, 0.45, 0.646153846,
0.06557377, 0.090909091, 0.125, 0,
0.032786885, 0, 0.125, 0.076923077,
0.049180328, 0, 0.125, 0.230769231), 4, 4, byrow = TRUE)

XE5 <- matrix(c(0, 0, 2.85, 3.99,
0.083333333, 0, 0, 0,
0, 0, 0, 0,
0.416666667, 0.1, 0, 0.1), 4, 4, byrow = TRUE)

mats_list <- list(XC3, XC4, XC5, XE3, XE4, XE5)
yr_ord <- c(1, 2, 3, 1, 2, 3)
pch_ord <- c(1, 1, 1, 2, 2, 2)

anth_lefkoMat <- create_lM(mats_list, anthframe, hstages = NA,
  historical = FALSE, poporder = 1, patchorder = pch_ord, yearorder = yr_ord)
  
XH3 <- matrix(c(0, 0, 0.1125, 1.05,
0.2, 0, 0, 0,
0, 0.5, 0, 0,
0.2, 0.5, 0, 0), 4, 4, byrow = TRUE)

XH3u <- matrix(c(0, 0, 0, 0,
0.2, 0, 0, 0,
0, 0.5, 0, 0,
0.2, 0.5, 0, 0), 4, 4, byrow = TRUE)

XH4 <- matrix(c(0, 0, 0, 0,
0, 0, 0.5, 0,
0.8, 0.5, 0.25, 0.25,
0.2, 0, 0, 0.75), 4, 4, byrow = TRUE)

XH4u <- matrix(c(0, 0, 0, 0,
0, 0, 0.5, 0,
0.8, 0.5, 0.25, 0.25,
0.2, 0, 0, 0.75), 4, 4, byrow = TRUE)

XH5 <- matrix(c(0, 0, 0.2, 1.05,
0, 0, 0, 0,
0.001, 0.001, 0.333333333, 0,
0.001, 0, 0, 0), 4, 4, byrow = TRUE)

XH5u <- matrix(c(0, 0, 0, 0,
0, 0, 0, 0,
0.001, 0.001, 0.333333333, 0,
0.001, 0, 0, 0), 4, 4, byrow = TRUE)

anth_lefkoMat <- add_lM(anth_lefkoMat, Amats = list(XH3, XH4, XH5),
  Umats = list(XH3u, XH4u, XH5u), patch = c(3, 3, 3), year = c(1, 2, 3))
  
}
\seealso{
\code{\link{create_lM}()}

\code{\link{delete_lM}()}

\code{\link{subset_lM}()}
}
