% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_model_manager.R
\name{register_custom_provider}
\alias{register_custom_provider}
\title{Register a custom LLM provider}
\usage{
register_custom_provider(provider_name, process_fn, description = NULL)
}
\arguments{
\item{provider_name}{Unique name for the custom provider}

\item{process_fn}{Function that processes LLM requests. Must accept parameters: prompt, model, api_key}

\item{description}{Optional description of the provider}
}
\value{
Invisible NULL
}
\description{
Register a custom LLM provider
}
\examples{
\dontrun{
register_custom_provider(
  provider_name = "my_provider",
  process_fn = function(prompt, model, api_key) {
    # Custom implementation
    response <- httr::POST(
      url = "your_api_endpoint",
      body = list(prompt = prompt),
      encode = "json"
    )
    return(httr::content(response)$choices[[1]]$text)
  }
)
}
}
